#Carnage x AshiskaArts
import app, net, ui, snd, wndMgr, dbg, os
import musicInfo, systemSetting
import localeInfo, constInfo, uiScriptLocale, uicommon
import ime
import serverInfo
import serverCommandParser
import time
import ServerStateChecker
import uiCommon
import _winreg
from _weakref import proxy

#define
ENABLE_MULTI_LANGUAGE_SYSTEM = 1

#Edit Website Links
REGISTER_LINK = "https://www.story2.ro/"
HOMEPAGE_LINK = "https://www.story2.ro/"
DISCORD_LINK = "https://discord.gg/ftj3jJHSDR"
YOUTUBE_LINK = "https://www.story2.ro/"

#Edit "NoName in your Servername"
REG_PATH = r"SOFTWARE\Story2"

def set_reg(name, value):
	try:
		_winreg.CreateKey(_winreg.HKEY_CURRENT_USER, REG_PATH)
		registry_key = _winreg.OpenKey(_winreg.HKEY_CURRENT_USER, REG_PATH, 0, _winreg.KEY_WRITE)
		_winreg.SetValueEx(registry_key, name, 0, _winreg.REG_SZ, value)
		_winreg.CloseKey(registry_key)
		return True
	except WindowsError:
		return False

def get_reg(name):
	try:
		registry_key = _winreg.OpenKey(_winreg.HKEY_CURRENT_USER, REG_PATH, 0, _winreg.KEY_READ)
		value, regtype = _winreg.QueryValueEx(registry_key, name)
		_winreg.CloseKey(registry_key)
		return str(value)
	except WindowsError:
		return None

class LoginWindow(ui.ScriptWindow):
	def __init__(self, stream):
		ui.ScriptWindow.__init__(self)
		
		net.SetPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(self)

		self.stream = stream
		self.isDown = False
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
		net.ClearPhaseWindow(net.PHASE_WINDOW_LOGIN, self)
		net.SetAccountConnectorHandler(0)

	def Open(self):
		ServerStateChecker.Create(self)

		self.loginFailureMsgDict={

			"ALREADY"	: localeInfo.LOGIN_FAILURE_ALREAY,
			"NOID"		: localeInfo.LOGIN_FAILURE_NOT_EXIST_ID,
			"WRONGPWD"	: localeInfo.LOGIN_FAILURE_WRONG_PASSWORD,
			"FULL"		: localeInfo.LOGIN_FAILURE_TOO_MANY_USER,
			"SHUTDOWN"	: localeInfo.LOGIN_FAILURE_SHUTDOWN,
			"REPAIR"	: localeInfo.LOGIN_FAILURE_REPAIR_ID,
			"BLOCK"		: localeInfo.LOGIN_FAILURE_BLOCK_ID,
			"WRONGMAT"	: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER,
			"QUIT"		: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER_TRIPLE,
			"BESAMEKEY"	: localeInfo.LOGIN_FAILURE_BE_SAME_KEY,
			"NOTAVAIL"	: localeInfo.LOGIN_FAILURE_NOT_AVAIL,
			"NOBILL"	: localeInfo.LOGIN_FAILURE_NOBILL,
			"BLKLOGIN"	: localeInfo.LOGIN_FAILURE_BLOCK_LOGIN,
			"WEBBLK"	: localeInfo.LOGIN_FAILURE_WEB_BLOCK,
			"BADSCLID"	: localeInfo.LOGIN_FAILURE_WRONG_SOCIALID,
			"AGELIMIT"	: localeInfo.LOGIN_FAILURE_SHUTDOWN_TIME,
		}

		self.loginFailureFuncDict = {
			"WRONGPWD"	: localeInfo.LOGIN_FAILURE_WRONG_PASSWORD,
			"WRONGMAT"	: localeInfo.LOGIN_FAILURE_WRONG_MATRIX_CARD_NUMBER,
			"QUIT"		: app.Exit,
		}

		self.SetSize(wndMgr.GetScreenWidth(), wndMgr.GetScreenHeight())
		self.SetWindowName("LoginWindow")
		self.__BuildKeyDict()

		self.__LoadScript("d:/ymir work/ui/login/loginwindow.py")

		if musicInfo.loginMusic != "":
			snd.SetMusicVolume(systemSetting.GetMusicVolume())
			snd.FadeInMusic("BGM/" + musicInfo.loginMusic)

		snd.SetSoundVolume(systemSetting.GetSoundVolume())

		ime.AddExceptKey(91)
		ime.AddExceptKey(93)
		self.SetChannel(0)
		self.CheckAccount()

		self.Show()
		app.ShowCursor()

	def Close(self):
		self.serverList					= None
		self.channelList				= None
		self.onPressKeyDict 			= None

		if musicInfo.loginMusic != "" and musicInfo.selectMusic != "":
			snd.FadeOutMusic("BGM/"+musicInfo.loginMusic)
	
		if self.stream.popupWindow:
			self.stream.popupWindow.Close()

		self.Hide()
		app.HideCursor()
		ime.ClearExceptKey()

	def __BuildKeyDict(self):
		onPressKeyDict = {}
		onPressKeyDict[app.DIK_F1]	= lambda : self.LoadAccount(0)
		onPressKeyDict[app.DIK_F2]	= lambda : self.LoadAccount(1)
		onPressKeyDict[app.DIK_F3]	= lambda : self.LoadAccount(2)
		onPressKeyDict[app.DIK_F4]	= lambda : self.LoadAccount(3)
		onPressKeyDict[app.DIK_F5]	= lambda : self.LoadAccount(4)
		onPressKeyDict[app.DIK_F6]	= lambda : self.LoadAccount(5)
		self.onPressKeyDict = onPressKeyDict

	def OnKeyDown(self, key):
		try:
			self.onPressKeyDict[key]()
		except KeyError:
			pass
		except:
			raise
		return TRUE

	def OnConnectFailure(self):
		snd.PlaySound("sound/ui/loginfail.wav")
		self.PopupNotifyMessage(localeInfo.LOGIN_CONNECT_FAILURE, self.EmptyFunc)

	def OnHandShake(self):
		snd.PlaySound("sound/ui/loginok.wav")
		self.PopupDisplayMessage(localeInfo.LOGIN_CONNECT_SUCCESS)
		constInfo.ACCOUNT_NAME = str(self.idEditLine.GetText())

	def OnLoginStart(self):
		self.PopupDisplayMessage(localeInfo.LOGIN_PROCESSING)

	def OnLoginFailure(self, error):
		ServerStateChecker.Request()
		try:
			loginFailureMsg = self.loginFailureMsgDict[error]
		except KeyError:
		
			loginFailureMsg = localeInfo.LOGIN_FAILURE_UNKNOWN  + error
		loginFailureFunc = self.loginFailureFuncDict.get(error, self.EmptyFunc)
		self.PopupNotifyMessage(loginFailureMsg, loginFailureFunc)
		snd.PlaySound("sound/ui/loginfail.wav")

	def __LoadScript(self, fileName):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("LoginWindow.__LoadScript.LoadObject")
		try:
			self.idEditLine			= self.GetChild("id")
			self.pwdEditLine		= self.GetChild("pwd")
			self.loginButton		= self.GetChild("login_button")
			self.exitButton			= self.GetChild("exit_button")
			self.channelButton = {
				0 : self.GetChild("select_btn_ch1"),
				1 : self.GetChild("select_btn_ch2"),
				2 : self.GetChild("select_btn_ch3"),
				3 : self.GetChild("select_btn_ch4"),
				4 : self.GetChild("select_btn_ch5"),
				5 : self.GetChild("select_btn_ch6")
			}

			self.accountData = {
				0 : [[self.GetChild("f1_delete_button"), self.GetChild("f1_save_button"), self.GetChild("f1_login_button")], self.GetChild("f1_account_text")],
				1 : [[self.GetChild("f2_delete_button"), self.GetChild("f2_save_button"), self.GetChild("f2_login_button")], self.GetChild("f2_account_text")],
				2 : [[self.GetChild("f3_delete_button"), self.GetChild("f3_save_button"), self.GetChild("f3_login_button")], self.GetChild("f3_account_text")],
				3 : [[self.GetChild("f4_delete_button"), self.GetChild("f4_save_button"), self.GetChild("f4_login_button")], self.GetChild("f4_account_text")],
				4 : [[self.GetChild("f5_delete_button"), self.GetChild("f5_save_button"), self.GetChild("f5_login_button")], self.GetChild("f5_account_text")],
				5 : [[self.GetChild("f6_delete_button"), self.GetChild("f6_save_button"), self.GetChild("f6_login_button")], self.GetChild("f6_account_text")],
				}

			self.languages = []
			self.languages.append(self.GetChild("en_flag"))
			self.languages.append(self.GetChild("ro_flag"))

		except:
			import exception
			exception.Abort("LoginWindow.__LoadScript.BindObject")

		for (channelID, channelButtons) in self.channelButton.items():
				channelButtons.SetEvent(ui.__mem_func__(self.SetChannel), channelID)

		for (key, item) in list(self.accountData.items()):
			if isinstance(item[0], list):
				item[0][0].SetEvent(ui.__mem_func__(self.DeleteAccount), key)
				item[0][1].SetEvent(ui.__mem_func__(self.SaveAccount), key)
				item[0][2].SetEvent(ui.__mem_func__(self.LoadAccount), key)

		self.idEditLine.SetReturnEvent(ui.__mem_func__(self.pwdEditLine.SetFocus))
		self.idEditLine.SetTabEvent(ui.__mem_func__(self.pwdEditLine.SetFocus))
		self.pwdEditLine.SetReturnEvent(ui.__mem_func__(self.__OnClickLoginButton))
		self.pwdEditLine.SetTabEvent(ui.__mem_func__(self.idEditLine.SetFocus))
		self.idEditLine.SetFocus()

		self.loginButton.SetEvent(ui.__mem_func__(self.__OnClickLoginButton))
		self.exitButton.SetEvent(ui.__mem_func__(self.__OnClickExitButton))
		self.GetChild("register_btn").SetEvent(ui.__mem_func__(self.GoRegister))
		
		self.GetChild("homepage_btn").SetEvent(ui.__mem_func__(self.GoHomepage))
		self.GetChild("discord_btn").SetEvent(ui.__mem_func__(self.GoDiscord))
		self.GetChild("youtube_btn").SetEvent(ui.__mem_func__(self.GoYouTube))

		self.GetChild("ch1_online").Hide()
		self.GetChild("ch2_online").Hide()
		self.GetChild("ch3_online").Hide()
		self.GetChild("ch4_online").Hide()
		self.GetChild("ch5_online").Hide()
		self.GetChild("ch6_online").Hide()

		for i in xrange(len(self.languages)):
			if ENABLE_MULTI_LANGUAGE_SYSTEM:
				self.languageLists = ["en","de","ro","pt","tr","it","pl","hu","es","ez"]
				bLanguage = self.languageLists[i]
				self.languages[i].SAFE_SetEvent(self.OnSelectLanguageButton, bLanguage)
			else:
				self.languages[i].Hide()

		self.__RefreshServerStateList()
		ServerStateChecker.Request()
		
	def getLanguageAsIndex(self, bLanguage):
		for i in xrange(len(self.languageList)):
			if self.languageList[i] == bLanguage:
				return i
				
	def getLanguage(self):
		f = open("locale.cfg", "r")
		return f.read()
		
	def setLanguage(self, language):
		self.language = language

	def OnUpdate(self):
		ServerStateChecker.Update()

	def LoadAccount(self, key):
		if get_reg("id_%d" % key):
			self.idEditLine.SetText(str(get_reg("id_%d" % key)))
			self.pwdEditLine.SetText(str(get_reg("pwd_%d" % key)))
			self.pwdEditLine.SetFocus()
			self.__OnClickLoginButton()
		else:
			self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_N_S)

	def SaveAccount(self, key):
		if get_reg("id_%d" % key):
			self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_N_S_D)
			return
		
		if self.idEditLine.GetText() == "" or self.pwdEditLine.GetText() == "":
			self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_SAVE)
			return
		
		set_reg("id_%d" % key, self.idEditLine.GetText())
		set_reg("pwd_%d" % key, self.pwdEditLine.GetText())
		self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_SAVED)
		self.CheckAccount()

	def CheckAccount(self):
		for i in xrange(6):
			if get_reg("id_%d" % i):
				self.accountData[i][1].SetText("F" + str(i+1) + " - " + str(get_reg("id_%d" % i)))
				self.accountData[i][1].SetPosition(10, 7)
				self.accountData[i][1].SetPackedFontColor(0xff767676)
				self.accountData[i][0][1].Hide()
				self.accountData[i][0][0].Show()
			else:
				self.accountData[i][1].SetText(uiScriptLocale.LOGIN_ACCOUNT_EMPTY)
				self.accountData[i][1].SetPosition(10, 7)
				self.accountData[i][1].SetPackedFontColor(0xff767676)
				self.accountData[i][0][1].Show()
				self.accountData[i][0][0].Hide()

	def DeleteAccount(self, key):
		import uiCommon
		self.questionDialog = uiCommon.QuestionDialog()
		self.questionDialog.SetText(uiScriptLocale.LOGIN_ACCOUNT_ASK_DELETE)
		self.questionDialog.SetAcceptEvent(lambda arg=key: self.AcceptDeleteAccount(arg))
		self.questionDialog.SetCancelEvent(ui.__mem_func__(self.CancelDeleteAccount))
		self.questionDialog.Open()
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(1)

	def AcceptDeleteAccount(self, key):
		if get_reg("id_%d" % key):
			set_reg("id_%d" % key, "")
			set_reg("pwd_%d" % key, "")
			self.OnCloseQuestionDialog()
			self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_DELETE)
		else:
			self.PopupNotifyMessage(uiScriptLocale.LOGIN_ACCOUNT_D_S)

		self.CheckAccount()

	def CancelDeleteAccount(self):
		self.OnCloseQuestionDialog()

	def OnCloseQuestionDialog(self):
		if not self.questionDialog:
			return
		self.questionDialog.Close()
		self.questionDialog = None
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)

	def SetChannel(self, ch):
		for key, button in self.channelButton.items():
			button.SetUp()

		self.channelButton[ch].Down()
		self.stream.SetConnectInfo(serverInfo.SRV1["host"], self.ChannelPort(ch, 0), serverInfo.SRV1["host"], self.ChannelPort("LOGIN"))
		net.SetMarkServer(serverInfo.SRV1["host"], self.ChannelPort("LOGO"))
		app.SetGuildMarkPath("10.tga")
		app.SetGuildSymbolPath("10")
		net.SetServerInfo(self.ChannelPort(ch, 2))
		
	def ChannelPort(self, ch, value=0):
		channel = {
			0	:	serverInfo.SRV_LIST[0][0][3][0][2],
			1	:	serverInfo.SRV_LIST[0][0][3][1][2],
			2	:	serverInfo.SRV_LIST[0][0][3][2][2],
			3	:	serverInfo.SRV_LIST[0][0][3][3][2],
			5	:	serverInfo.SRV_LIST[0][0][3][3][2],
			6	:	serverInfo.SRV_LIST[0][0][3][3][2],
		}
		if ch == "LOGIN":
			return serverInfo.SRV_LIST[0][0][1]
		elif ch == "LOGO":
			return channel[0]
		elif value == 2:
			return serverInfo.SRV_LIST[0][0][0] + ", CH%s" % (ch+1)
		else:
			return channel[ch]

	def Connect(self, id, pwd):
		if constInfo.SEQUENCE_PACKET_ENABLE:
			net.SetPacketSequenceMode()
			
		constInfo.LastAccount = id.lower()

		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(localeInfo.LOGIN_CONNETING, self.EmptyFunc, localeInfo.UI_CANCEL)

		self.stream.SetLoginInfo(id, pwd)
		self.stream.Connect()
		
	def PopupDisplayMessage(self, msg):
		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg)

	def PopupNotifyMessage(self, msg, func=0):
		if not func:
			func = self.EmptyFunc

		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg, func, localeInfo.UI_OK)

	def OnPressExitKey(self):
		if self.stream.popupWindow:
			self.stream.popupWindow.Close()
		self.stream.SetPhaseWindow(0)
		return TRUE

	def __GetRegionID(self):
		return 0

	def __GetServerID(self):
		return 0

	def __GetChannelID(self):
		return self.channelList.GetSelectedItem()

	def EmptyFunc(self):
		pass

	def NotifyChannelState(self, key, state):
		serverInfo.SERVER_STATE_TABLE[key] = state
		
		serverIndex = self.__GetServerID()
		if (key / 10) == serverIndex:
			try:
				stateName = serverInfo.STATE_DICT[state]
				stateNameText = serverInfo.STATE_DICT[state]
			except:
				stateName = serverInfo.STATE_NONE
				stateNameText = serverInfo.STATE_TEXT_NONE

			channelIndex = key % 10
			channelName = serverInfo.SRV_LIST[0][serverIndex][3][channelIndex][0]

			if state >= 1:
				self.GetChild("ch%d_online" % (int(channelIndex)+1)).Show()
				self.GetChild("ch%d_offline" % (int(channelIndex)+1)).Hide()
			else:
				self.GetChild("ch%d_online" % (int(channelIndex)+1)).Hide()
				self.GetChild("ch%d_offline" % (int(channelIndex)+1)).Show()

	def __RequestServerStateList(self):
		serverIndex = self.__GetServerID()
		channelData = None

		try:
			channelData = serverInfo.SRV_LIST[0][serverIndex][3]
		except:
			print "LoginWindow::__RequestServerStateList"
			return

		ServerStateChecker.Request()

	def __RefreshServerStateList(self):
		serverIndex = self.__GetServerID()
		channelData = None

		try:
			channelData = serverInfo.SRV_LIST[0][0][3]
		except:
			print "LoginWindow::__RefreshServerStateList"
			return
			
		for index, channel in enumerate(channelData):
			ServerStateChecker.AddChannel(index, channel[1], channel[2])
			stateName = serverInfo.STATE_NONE

	if ENABLE_MULTI_LANGUAGE_SYSTEM:
		def _CodePageReplace(self, langName):
			cpReplace = {
				"en": (1252, 1252),
				"ro": (1252, 1252),
			}
			try:
				return cpReplace[langName]
			except:
				return 1252, 1252

		def OnSelectLanguageButton(self, lang):
			canUseLang = ["en", "ro"]
			if lang not in canUseLang:
				self.PopupNotifyMessage(uiScriptLocale.LOGIN_SELECT_UNKNOWN_LANG)
				return
			localeCfg = open("locale.cfg", "w+")
			cp1, cp2 = self._CodePageReplace(lang)
			localeCfg.write("%s %s %s" % (cp1, cp2, lang))
			localeCfg.close()
			os.system('start Metin2Release.exe')
			app.Exit()

	def GoRegister(self):
		import os
		os.system('@echo off && explorer ' + REGISTER_LINK)
		return TRUE
	def GoHomepage(self):
		import os
		os.system('@echo off && explorer ' + HOMEPAGE_LINK)
		return TRUE
	def GoDiscord(self):
		import os
		os.system('@echo off && explorer ' + DISCORD_LINK)
		return TRUE
	def GoYouTube(self):
		import os
		os.system('@echo off && explorer ' + YOUTUBE_LINK)
		return TRUE

	def __OnClickLoginButton(self):
		id = self.idEditLine.GetText()
		pwd = self.pwdEditLine.GetText()

		if len(id)==0:
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_ID, self.EmptyFunc)
			return

		if len(pwd)==0:
			self.PopupNotifyMessage(localeInfo.LOGIN_INPUT_PASSWORD, self.EmptyFunc)
			return

		self.Connect(id, pwd)

	def __OnClickExitButton(self):
		if self.stream.popupWindow:
			self.stream.popupWindow.Close()
		
		self.stream.SetPhaseWindow(0)
		return TRUE